/* Maski bitw dotyczce okrelenia praw dostpu i typu pliku. Przedstawione
 * poniej nazwy s zgodne z POSIX, poszczeglne systemy mog mie wasne 
 * rozszerzenia.
 */

define('S_IFMT',0170000);   // maska dla wszystkich typw 
define('S_IFSOCK',0140000); // typ: gniazdo 
define('S_IFLNK',0120000);  // typ: dowizanie symboliczne
define('S_IFREG',0100000);  // typ: tradycyjny plik
define('S_IFBLK',0060000);  // typ: urzdzenie blokowe
define('S_IFDIR',0040000);  // typ: katalog
define('S_IFCHR',0020000);  // typ: urzdzenie znakowe
define('S_IFIFO',0010000);  // typ: fifo 
define('S_ISUID',0004000);  // bit set-uid  
define('S_ISGID',0002000);  // bit set-gid  
define('S_ISVTX',0001000);  // bit sticky  
define('S_IRWXU',00700);    // maska praw waciciela 
define('S_IRUSR',00400);    // waciciel: prawo odczytu 
define('S_IWUSR',00200);    // waciciel: prawo zapisu 
define('S_IXUSR',00100);    // waciciel: prawo wykonywania 
define('S_IRWXG',00070);    // maska praw grupy 
define('S_IRGRP',00040);    // grupa: prawo odczytu 
define('S_IWGRP',00020);    // grupa: prawo zapisu 
define('S_IXGRP',00010);    // grupa: prawo wykonywania 
define('S_IRWXO',00007);    // maska praw pozostaych uytkownikw 
define('S_IROTH',00004);    // pozostali: prawo odczytu 
define('S_IWOTH',00002);    // pozostali: prawo zapisu 
define('S_IXOTH',00001);    // pozostali: prawo wykonywania 

/* mode_string() to funkcja pomocnicza przyjmujca tryb w postaci semkowej
 * i zwracajca 10-znakowy tekst typu pliku i praw dostpu do niego
 * Jest to wersja PHP funkcji mode_string() z pakietu GNU fileutils.
 */
$mode_type_map = array(S_IFBLK => 'b', S_IFCHR => 'c',
                       S_IFDIR => 'd', S_IFREG => '-',
                       S_IFIFO => 'p', S_IFLNK => 'l',
                       S_IFSOCK => 's');
function mode_string($mode) {
    global $mode_type_map;
    $s = '';
    $mode_type = $mode & S_IFMT;
    // Dodanie litery typu
    $s .= isset($mode_type_map[$mode_type]) ?
          $mode_type_map[$mode_type] : '?';
  
  // Wyznaczenie praw waciciela 
  $s .= $mode & S_IRUSR ? 'r' : '-';
  $s .= $mode & S_IWUSR ? 'w' : '-';
  $s .= $mode & S_IXUSR ? 'x' : '-';

  // Wyznaczenie praw grupy
  $s .= $mode & S_IRGRP ? 'r' : '-';
  $s .= $mode & S_IWGRP ? 'w' : '-';
  $s .= $mode & S_IXGRP ? 'x' : '-';

  // Wyznaczenie praw pozostaych uytkownikw 
  $s .= $mode & S_IROTH ? 'r' : '-';
  $s .= $mode & S_IWOTH ? 'w' : '-';
  $s .= $mode & S_IXOTH ? 'x' : '-';

  // Zmiana liter praw wykonywania dla bitw set-uid, set-gid i sticky 
  if ($mode & S_ISUID) {
      // Znak 'S'  wystpuje bit set-uid, ale waciciel nie ma praw wykonywania 
      $s[3] = ($s[3] == 'x') ? 's' : 'S';
  }

  if ($mode & S_ISGID) {
      // Znak 'S'  wystpuje bit set-gid, ale grupa nie ma prawa wykonywania 
      $s[6] = ($s[6] == 'x') ? 's' : 'S';
  }

  if ($mode & S_ISVTX) {
      // Znak 'T'  wystpuje bit sticky, ale uytkownicy nie maj prawa wykonywania 
      $s[9] = ($s[9] == 'x') ? 't' : 'T';
  }
  
  return $s;
}

// Rozpoczcie dziaania od gwnego katalogu, jeli nie zosta wskazany inny.
$dir = isset($_GET['dir']) ? $_GET['dir'] : '';

// Odszukanie katalogu ($dir) w systemie plikw
$real_dir = realpath($_SERVER['DOCUMENT_ROOT'].$dir);
// Przekazanie gownego katalogu dokumentw do funkcji realpath zapewnia odpowiedni
// obsug znakw ukonika i odwrotnego ukonika
$real_docroot = realpath($_SERVER['DOCUMENT_ROOT']);

// Sprawdzenie, czy katalog $real_dir znajduje si wewntrz gwnego katalogu dokumentw
if (! (($real_dir == $real_docroot) ||
       ((strlen($real_dir) > strlen($real_docroot)) &&
        (strncasecmp($real_dir,$real_docroot.DIRECTORY_SEPARATOR,
        strlen($real_docroot.DIRECTORY_SEPARATOR)) == 0)))) {
    die("$dir nie znajduje si wewntrz gwnego katalogu dokumentw ");
}

// Usunicie informacji o gwnym katalogu dokumentw ze cieki $dir 
$dir = substr($real_dir,strlen($real_docroot)+1);

// Czy otwierany jest katalog?
if (! is_dir($real_dir)) {
    die("$real_dir nie jest katalogiem ");
}

print '<pre><table>';

// Odczytanie kadego elementu katalogu 
foreach (new DirectoryIterator($real_dir) as $file) {
    // Zamiana wartoci uid na nazw waciciela
    if (function_exists('posix_getpwuid')) {
        $user_info = posix_getpwuid($file->getOwner());
    } else {
        $user_info = $file->getOwner();
    }

    // Zamiana wartoci gid na nazw grupy 
    if (function_exists('posix_getgrid')) {
        $group_info = $file->getGroup();
    } else {
        $group_info = $file->getGroup();
    }

    // Zwikszenie czytelnoci daty 
    $date = date('M d H:i',$file->getMTime());

    // Przeksztacenie semkowego zapisu praw dostpu w czytelny cig tekstowy 
    $mode = mode_string($file->getPerms());

    $mode_type = substr($mode,0,1);
    if (($mode_type == 'c') || ($mode_type == 'b')) {
        /* Jeli jest to urzdzenie blokowe lub znakowe, zamiast rozmiaru pliku
         * zostanie wywietlony gwny i podrzdny typ urzdzenia */
        $statInfo = lstat($file->getPathname());
        $major = ($statInfo['rdev'] >> 8) & 0xff;
        $minor = $statInfo['rdev'] & 0xff;
        $size = sprintf('%3u, %3u',$major,$minor);
    } else {
        $size = $file->getSize();
    }

    // Utworzenie znacznikw <a href=""> wok nazw plikw.
    // Brak odsyacza dla biecego katalogu.
    if ('.' == $file->getFilename()) {
        $href = $file->getFilename();
    } else {
        // Pominicie cigu ".." w odsyaczu do katalogu nadrzdnego
        if ('..' == $file->getFilename()) {
            $href = urlencode(dirname($dir));
        } else {
            $href = urlencode($dir) . '/' . urlencode($file);
        }
        
        /* Wszystko poza znakiem "/" powinno zosta zakodowane w sposb 
           waciwy dla adresw URL */
        $href = str_replace('%2F','/',$href);

        // Przegldanie innych katalogw za pomoc skryptu web-ls
        if ($file->isDir()) {
            $href = sprintf('<a href="%s?dir=/%s">%s</a>',
                            $_SERVER['PHP_SELF'],$href,$file);
        } else {
            // Odsyacze umoliwiajce pobranie plikw
            $href= sprintf('<a href="%s">%s</a>',$href,$file);
        }

        // Wywietlenie elementu docelowego dla dowizania
        if ('l' == $mode_type) {
            $href .= ' -&gt; ' . readlink($file->getPathname());
        }
    }

    // Wywietlenie odpowiednich informacji o pliku 
    printf('<tr><td>%s</td><td align="right">%s</td>
            <td align="right">%s</td><td align="right">%s</td>
            <td align="right">%s</td><td>%s</td></tr>',
           $mode,                // sformatowany cig o typie pliku
           $user_info['name'],   // nazwa waciciela 
           $group_info['name'],  // nazwa grupy
           $size,                // rozmiar pliku (lub numery urzdzenia) 
           $date,                // data i czas ostatniej modyfikacji
           $href);               // odsyacz umoliwiajcy przegldanie lub pobranie
}

print '</table></pre>';
?>
